IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_CUSTO_MEDIO_GERACAO_EMPRESA]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_CUSTO_MEDIO_GERACAO_EMPRESA];
GO
GO
--EXEC P_EST_PROD_PRECO_CUSTO_MEDIO_GERACAO_EMPRESA
CREATE PROCEDURE P_EST_PROD_PRECO_CUSTO_MEDIO_GERACAO_EMPRESA
AS
    SET NOCOUNT ON;
    SET ANSI_WARNINGS OFF;
    DECLARE @CD_EMP INT;
	DECLARE @CD_PROD INT;
	DECLARE @VLR_CUSTO_MD MONEY;
	DECLARE @VLR_CUSTO_GER MONEY
	DECLARE @VLR_CUSTO MONEY
	DECLARE @ANALISA_CUSTO_PRODUTO_PRECIFICACAO INT
	print 'P_EST_PROD_PRECO_CUSTO_MEDIO_GERACAO_EMPRESA'
    SET @ANALISA_CUSTO_PRODUTO_PRECIFICACAO = ISNULL(
                                (
                                    SELECT VALOR
                                    FROM PRC_EMP_CONFIG
                                    WHERE CD_CHAVE = 'ANALISA_CUSTO_PRODUTO_PRECIFICACAO'
                                ), 0);	
										 
									 
	IF @ANALISA_CUSTO_PRODUTO_PRECIFICACAO=0
		BEGIN
			DELETE FROM EST_PROD_CUSTO_GRP_PROC_PENDENTE
			PRINT 'NAO PROCESSA ANALISE DE CUSTO PRODUTO'
			RETURN
		END
			
	
	CREATE TABLE #RsProd (CD_EMP INT,
					CD_PROD INT)
	
	INSERT INTO #RsProd
	SELECT
		DISTINCT CD_EMP,
		CD_PROD
	FROM
		EST_PROD_CUSTO_GRP_PROC_PENDENTE
		
    BEGIN TRY
	   DECLARE ProcProdPrecoCusto CURSOR FAST_FORWARD FOR
		SELECT
			EST_PROD_CPL.CD_EMP,
			EST_PROD_CPL.CD_PROD,
			ROUND(CASE WHEN SUM(QT_EST) > 0 THEN
				SUM(VLR_CUSTO_MD*QT_EST)/SUM(CASE WHEN QT_EST <= 0 THEN 0 ELSE QT_EST END)
			ELSE
				AVG(VLR_CUSTO_MD)
			END,2) AS VLR_CUSTO_MD,
			ROUND(CASE WHEN SUM(QT_EST) > 0 THEN
				SUM(VLR_CUSTO_GER*QT_EST)/SUM(CASE WHEN QT_EST <= 0 THEN 0 ELSE QT_EST END)
			ELSE
				AVG(VLR_CUSTO_GER)
			END,2) AS VLR_CUSTO_GER,
			ROUND(CASE WHEN SUM(QT_EST) > 0 THEN
				SUM(VLR_CUSTO*QT_EST)/SUM(CASE WHEN QT_EST <= 0 THEN 0 ELSE QT_EST END)
			ELSE
				AVG(VLR_CUSTO)
			END,2) AS VLR_CUSTO
		FROM
			EST_PROD_CPL  INNER JOIN #RsProd R ON
			EST_PROD_CPL.CD_EMP = R.CD_EMP AND
			EST_PROD_CPL.CD_PROD = R.CD_PROD
		GROUP BY
			EST_PROD_CPL.CD_EMP,
			EST_PROD_CPL.CD_PROD

	   OPEN ProcProdPrecoCusto;
	   FETCH NEXT FROM ProcProdPrecoCusto INTO @CD_EMP,@CD_PROD,@VLR_CUSTO_MD,@VLR_CUSTO_GER,@VLR_CUSTO;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
			 PRINT 'Produto.: ' + CONVERT(VARCHAR(15), @CD_PROD) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';

			UPDATE
				EST_PROD
			SET 
				VLR_CUSTO_MD_GRP=@VLR_CUSTO_MD,
				VLR_CUSTO_GER_GRP=@VLR_CUSTO_GER,
				VLR_CUSTO_GRP = CASE WHEN VLR_CUSTO_GRP = 0 THEN @VLR_CUSTO ELSE VLR_CUSTO_GRP END
			WHERE
				CD_EMP = @CD_EMP
				AND CD_PROD=@CD_PROD
				AND (VLR_CUSTO_MD_GRP+VLR_CUSTO_GER_GRP+VLR_CUSTO_GRP) <> (@VLR_CUSTO_MD+@VLR_CUSTO_GER+@VLR_CUSTO)
			
			IF (@VLR_CUSTO_MD+@VLR_CUSTO_GER+@VLR_CUSTO) > 0 
			BEGIN
				DELETE
					EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE
				FROM
					EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE INNER JOIN EST_PROD_PRECO_ALT ON
					EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP = EST_PROD_PRECO_ALT.CD_EMP AND
					EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO = EST_PROD_PRECO_ALT.CD_ALT_PRECO 
					INNER JOIN EST_PROD_PRECO_ALT_CPL ON
					EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND
					EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO AND
					EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD = EST_PROD_PRECO_ALT_CPL.CD_PROD 
				WHERE
					APLICADO IN (0,2)
					AND EST_PROD_PRECO_ALT_CPL.VLR_CUSTO=0
					AND EST_PROD_PRECO_ALT_CPL.CD_EMP=@CD_EMP
					AND EST_PROD_PRECO_ALT_CPL.CD_PROD = @CD_PROD
			END
			  FETCH NEXT FROM ProcProdPrecoCusto INTO @CD_EMP,@CD_PROD,@VLR_CUSTO_MD,@VLR_CUSTO_GER,@VLR_CUSTO;
		  END ;

	   PRINT 'Concluido.' ;
	   CLOSE ProcProdPrecoCusto ;
	   DEALLOCATE ProcProdPrecoCusto ;

	DELETE
		P
	FROM
		EST_PROD_CUSTO_GRP_PROC_PENDENTE P INNER JOIN #RsProd R ON
		P.CD_EMP = R.CD_EMP AND
		P.CD_PROD = R.CD_PROD 

DROP TABLE #RsProd

	END TRY
    BEGIN CATCH

		CLOSE ProcProdPrecoCusto ;
		DEALLOCATE ProcProdPrecoCusto ;
		DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
		DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
		DECLARE @ErrorState INT = ERROR_STATE();

		INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
			SELECT
				ERROR_NUMBER()	  AS numero
				,@ErrorSeverity	  AS severidade
				,@ErrorState		  AS estado
				,'P_EST_PROD_PRECO_CUSTO_MEDIO_GERACAO_EMPRESA'	  AS rotina
				,ERROR_LINE()		  AS linha
				,@ErrorMessage	  AS mensagem
				,GETDATE()		  AS dtErro ;

	    RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);

    END CATCH;
